import enum

from pydantic import BaseModel


class Destination(str, enum.Enum):
    operator = 'operator'
    chat = 'chat'


class SamsaraMessageRequest(BaseModel):
    to_chat_with_puid: str
    destination: Destination
    line: str = 'default'
    from_name: str
    text: str
    meta: dict[str, list]
