import asyncssh

from contextlib import asynccontextmanager


@asynccontextmanager
async def sftp_client(
    host: str,
    username: str,
    password: str,
    **kwargs,
) -> asyncssh.SFTPClient:
    client = None
    try:
        connect = await asyncssh.connect(
            host=host,
            username=username,
            password=password,
            known_hosts=None,
            **kwargs,
        )
        client = await connect.start_sftp_client()
        yield client
    finally:
        if client:
            client.exit()
