import logging
from async_clients.clients.base import BaseClient
from async_clients.auth_types import TVM2

from intranet.trip.src.config import settings

logger = logging.getLogger(__name__)


class StaffClient(BaseClient):

    AUTH_TYPES = {TVM2}

    async def get_trips(self, params: dict) -> dict:
        return await self._make_request(
            method='get',
            path='trips-api/raw_history',
            params=params,
        )

    async def save_trip(self, data: dict, params: dict) -> dict:
        return await self._make_request(
            method='post',
            path='trips-api/save/',
            json=data,
            params=params,
        )

    async def get_assignments(self, params: dict) -> dict[str, dict]:
        return await self._make_request(
            method='get',
            path='trips-api/assignments',
            params=params,
            timeout=settings.STAFF_GET_ASSIGNMENT_TIMEOUTS,
        )

    async def get_trips_by_uuids(self, data: dict) -> list[dict]:
        return await self._make_request(
            method='post',
            path='trips-api/raw',
            json=data,
        )
