from async_clients.clients.base import BaseClient
from async_clients.auth_types import TVM2


class StaffApiClient(BaseClient):

    AUTH_TYPES = {TVM2}

    async def get_persons(self, params: dict) -> dict:
        if '_limit' not in params:
            params['_limit'] = 10000

        return await self._make_request(
            method='get',
            path='persons',
            params=params,
        )

    async def get_person(self, params: dict) -> dict:
        params['_one'] = '1'

        return await self._make_request(
            method='get',
            path='persons',
            params=params,
        )

    async def get_organizations(self, params: dict):
        if '_limit' not in params:
            params['_limit'] = 10000

        return await self._make_request(
            method='get',
            path='organizations',
            params=params,
        )
