import logging

from async_clients.clients.base import BaseClient
from async_clients.auth_types import OAuth

from intranet.trip.src.config import settings


logger = logging.getLogger(__name__)


class TrackerClient(BaseClient):

    AUTH_TYPES = {OAuth}

    async def create_comment(
            self,
            issue: str,
            text: str,
            summonees: list[str] = None,
            maillist_summonees: list[str] = None,
            attachment_ids: list[int] = None,
    ) -> dict:
        data = {
            'text': text,
            'summonees': summonees or [],
            'maillistSummonees': maillist_summonees or [],
        }
        if attachment_ids:
            data['attachmentIds'] = attachment_ids
        return await self._make_request(
            method='post',
            path=f'issues/{issue}/comments',
            json=data,
        )

    async def create_attachment(self, file_data: bytes, file_name: str = None) -> dict:
        return await self._make_request(
            method='post',
            path='attachments',
            params={
                'filename': file_name or 'file',
            },
            data={
                'file': file_data,
            },
        )

    async def add_attachment(self, issue: str, file_data: bytes, file_name: str = None) -> dict:
        file_name = file_name or 'file'
        return await self._make_request(
            method='post',
            path=f'issues/{issue}/attachments',
            data={
                file_name: file_data,
            },
        )


tracker_api = TrackerClient(
    host=settings.tracker_api_url,
    token=settings.TRACKER_ROBOT_OAUTH,
    timeout=5,
)
