from jinja2 import Template
from library.python import resource

from intranet.trip.src.lib.tracker.api import tracker_api


async def notify_by_tracker_comment(
    issue: str,
    template_name: str,
    context: dict,
    summonees: list[str] = None,
    maillist_summonees: list[str] = None,
    attachment_ids: list[int] = None,
) -> None:
    path = 'intranet/trip/src/templates/tracker/' + template_name
    template = resource.resfs_read(path).decode('utf-8')
    text = Template(template).render(**context)
    await tracker_api.create_comment(issue, text, summonees, maillist_summonees, attachment_ids)
