from transliterate.base import TranslitLanguagePack


class ICAORussianLanguagePack(TranslitLanguagePack):
    """
    Custom transliteration language pack according to ICAO standard (for avia tickets)
    See more:
        - standard: https://www.transliteratciia.ru/transliteraciya-imeni-i-familii-dlya-aviabileta/
        - language pack registering:
            https://github.com/barseghyanartur/transliterate#registering-a-custom-language-pack
    """

    language_code = 'ru_icao'
    language_name = 'Russian (ICAO standard)'
    mapping = (
        'abvgdeziklmnoprstufyABVGDEZIKLMNOPRSTUFY',
        'абвгдезиклмнопрстуфыАБВГДЕЗИКЛМНОПРСТУФЫ'
    )
    reversed_specific_mapping = (
        'ёйэЁЙЭ',
        'eieEIE'
    )
    pre_processor_mapping = {
        'zh': 'ж',
        'Zh': 'Ж',
        'kh': 'х',
        'Kh': 'Х',
        'ts': 'ц',
        'Ts': 'Ц',
        'ch': 'ч',
        'Ch': 'Ч',
        'sh': 'ш',
        'Sh': 'Ш',
        'shch': 'щ',
        'Shch': 'Щ',
        'ie': 'ъ',
        'Ie': 'Ъ',
        'iu': 'ю',
        'Iu': 'Ю',
        'ia': 'я',
        'Ia': 'Я'
    }

    def translit(self, value, reversed=False, strict=False, fail_silently=True):
        """
        As soft sign (Ь/ь) has no mapping, we need to forcely remove them from string
        """
        value = value.replace('ь', '').replace('Ь', '')
        return super().translit(
            value,
            reversed=reversed,
            strict=strict,
            fail_silently=fail_silently,
        )
