import aiofiles

from contextlib import closing
from typing import AsyncGenerator
from xml.etree.ElementTree import XMLPullParser


async def file_reader(filename) -> AsyncGenerator:
    async with aiofiles.open(filename, 'r') as file:
        async for line in file:
            yield line


async def file_xml_parser(filename: str) -> AsyncGenerator:
    parser = XMLPullParser(['start', 'end'])
    with closing(parser) as parser:
        async for line in file_reader(filename=filename):
            parser.feed(line)
            yield parser.read_events()


async def text_xml_parser(raw_xml: str) -> AsyncGenerator:
    parser = XMLPullParser(['start', 'end'])
    with closing(parser) as parser:
        parser.feed(raw_xml)
        yield parser.read_events()
