from intranet.trip.src.exceptions import WorkflowError, PermissionDenied


class Action:

    action_name = None

    async def check_permissions(self) -> None:
        raise NotImplementedError

    async def is_available(self) -> bool:
        try:
            await self.check_permissions()
        except (PermissionDenied, WorkflowError):
            return False
        else:
            return True

    async def execute(self, *args, **kwargs):
        """
        Совершить действие без проверки прав.
        """
        raise NotImplementedError

    async def check_and_execute(self, *args, **kwargs):
        """
        Проверить, может ли пользователь совершить действие.
        Если может, то совершить его.
        Если не может, то зарейзить ошибку.
        """
        await self.check_permissions()
        return await self.execute(*args, **kwargs)
