import logging

from intranet.trip.src.api.schemas import EventIn
from intranet.trip.src.enums import PTStatus
from intranet.trip.src.unit_of_work import UnitOfWork


logger = logging.getLogger(__name__)


async def process_notification(uow: UnitOfWork, event_in: EventIn):
    async with uow:
        person_trip = await uow.person_trips.get_person_trip_by_aeroclub_id(
            aeroclub_journey_id=event_in.aeroclub_journey_id,
            aeroclub_trip_id=event_in.aeroclub_trip_id,
        )
        if (
            person_trip.status in (PTStatus.executing, PTStatus.executed)
            and event_in.services
        ):
            uow.add_job(
                'process_aeroclub_event_task',
                event=event_in.dict(),
                unique=False,
            )
