import logging

from intranet.trip.src.api.schemas import ApprovementData
from intranet.trip.src.config import settings
from intranet.trip.src.unit_of_work import UnitOfWork


logger = logging.getLogger(__name__)


async def fill_approvement_data(
        uow: UnitOfWork,
        approvement_data: ApprovementData,
) -> None:
    is_automatic_approval = approvement_data.is_automatic_approval
    if is_automatic_approval is not None:
        approvement_data.flow_context['is_automatic_approval'] = is_automatic_approval
        return
    staff_trip_uuid = approvement_data.trip_uuid
    person_login = approvement_data.flow_context.get('author_login')
    person_id = await uow.persons.get_id_by_login(person_login)
    trip_id = await uow.trips.get_id_by_trip_uuid(staff_trip_uuid=staff_trip_uuid)

    if trip_id is None or person_id is None:
        approvement_data.flow_context['is_automatic_approval'] = False
        return

    person_trip = await uow.person_trips.get_detailed_person_trip(
        trip_id=trip_id,
        person_id=person_id,
    )

    is_automatic_approval = True

    if len(person_trip.purposes) == 0:
        is_automatic_approval = False

    for purpose in person_trip.purposes:
        purpose_id = purpose.purpose_id
        if purpose_id not in settings.AUTOMATIC_APPROVAL_PURPOSES:
            is_automatic_approval = False

        if purpose_id == settings.MEETING_WITH_COLLEAGS_PURPOSE_ID:
            count_pt_with_purpose = await uow.person_trips.get_person_trips_with_purpose_count(
                person_id=person_id,
                purpose_id=purpose_id,
                month=person_trip.gap_date_from.month,
            )
            if count_pt_with_purpose != 1:
                is_automatic_approval = False

    approvement_data.flow_context['is_automatic_approval'] = is_automatic_approval
