from intranet.trip.src.api.schemas import SuggestResponse
from intranet.trip.src.lib.utils import safe_getitem

from intranet.trip.src.logic.providers import BaseConverter


class AeroclubReferencesConverterOut(BaseConverter):
    """
    aeroclub /references response -> trip /cities response
    """
    def _convert_item(self, item: dict) -> SuggestResponse:
        return SuggestResponse(
            target_id=item['id'],
            city=safe_getitem(item, ['name', self.lang]),
            country=safe_getitem(item, ['located_in', 'name', self.lang]),
        )

    def convert(self, data: list[dict]) -> list[SuggestResponse]:
        return [self._convert_item(item) for item in data]
