from intranet.trip.src.api.schemas import SuggestResponse

from intranet.trip.src.logic.providers import BaseConverter


class AviacenterAirportsConverterOut(BaseConverter):
    """
    aviacenter /avia/airports response -> trip /cities response
    """
    @staticmethod
    def _convert_item(item) -> SuggestResponse:
        return SuggestResponse(
            target_id=item['city_iata_code'],
            city=item['city_name'],
            country=item['country_name'],
        )

    def convert(self, data) -> list[SuggestResponse]:
        return [self._convert_item(item) for item in data['cities'].values()]


class AviacenterStationsConverterOut(BaseConverter):
    """
    aviacenter /train/stations response -> trip /cities response
    """
    @staticmethod
    def _convert_item(item) -> SuggestResponse:
        return SuggestResponse(
            target_id=item['parent_code'],
            city=item['parent_name'],
            country=item['country_code'],
        )

    def convert(self, data) -> list[SuggestResponse]:
        return [self._convert_item(item) for item in data['items']]


class AviacenterCitiesConverterOut(BaseConverter):
    """
    aviacenter /cities response -> trip /cities response
    """
    @staticmethod
    def _convert_item(item) -> SuggestResponse:
        return SuggestResponse(
            target_id=item['iata'],
            city=item['name'],
            country=item['country'],
        )

    def convert(self, data) -> list[SuggestResponse]:
        return [self._convert_item(item) for item in data['cities']]
