from intranet.trip.src.enums import Provider
from intranet.trip.src.models.person import User
from intranet.trip.src.logic.providers import ProviderGateway
from intranet.trip.src.logic.providers.aeroclub.gateway import AeroclubGateway
from intranet.trip.src.logic.providers.aviacenter.gateway import AviacenterGateway


def create_provider_gateway(user: User, provider: Provider = None) -> ProviderGateway:
    provider = provider or user.company.provider or Provider.aeroclub
    if provider == Provider.aeroclub:
        return AeroclubGateway(user=user)
    elif provider == Provider.aviacenter:
        return AviacenterGateway(user=user)
