from intranet.trip.src.logic.triggers.drive import DriveTrigger


class TriggerExecutor:
    def __init__(self, uow, person_trip):
        self.uow = uow
        self.person_trip = person_trip

    def get_triggers(self):
        triggers = [
            DriveTrigger,
        ]
        for trigger in triggers:
            yield trigger(self.uow, self.person_trip)

    async def run(self):
        for trigger in self.get_triggers():
            await trigger.execute()
