import os
import subprocess

from .config import settings


def dbshell():
    pgshell = os.environ.get('PGSHELL', 'psql')

    db_settings = settings.db_settings
    command = ''

    if db_settings.get('password'):
        command = 'PGPASSWORD={password} '.format(
            password=db_settings.get('password'))

    target_session_attrs_opt = 'target_session_attrs=read-write'

    command += (
        '{pgshell} -d "'
        'host={host} '
        'port={port} '
        'dbname={database} '
        'user={user} '
        '{target_session_attrs_opt}"'
    ).format(
        pgshell=pgshell,
        target_session_attrs_opt=target_session_attrs_opt,
        **db_settings
    )
    subprocess.call(command, shell=True)
