from fastapi.responses import JSONResponse


class BaseAuthException(Exception):
    def __init__(self, status_code: int, message: str):
        self.status_code = status_code
        self.message = message
        self.json_response = JSONResponse(
            status_code=self.status_code,
            content={'detail': self.message},
        )

    def __str__(self):
        return f'{self.status_code}: {self.message}'


class DeactivatedException(BaseAuthException):
    """
    'User is deactivated or is dismissed' Exception
    """
    def __init__(self):
        super().__init__(403, 'USER_DEACTIVATED')


class RejectedException(BaseAuthException):
    """
    'User is deactivated or is dismissed' Exception
    """
    def __init__(self):
        super().__init__(403, 'USER_REJECTED')


class EmptyCompanyException(BaseAuthException):
    """
    'Company not set for user' Exception
    """
    def __init__(self):
        super().__init__(401, 'EMPTY_COMPANY')


class ForbiddenException(BaseAuthException):
    """
    'Not authenticated in trip' Exception
    """
    def __init__(self):
        super().__init__(403, 'FORBIDDEN')


class NotConfirmedEmailException(BaseAuthException):
    """
    'Email must be confirmed' Exception
    """
    def __init__(self):
        super().__init__(401, 'NOT_CONFIRMED_EMAIL')


class NotRegisteredException(BaseAuthException):
    """
    'Not registered in the Trip (B2B)' Exception
    """
    def __init__(self):
        super().__init__(401, 'NOT_REGISTERED')
