from typing import Optional

from intranet.trip.src.config import settings
from intranet.trip.src.db.gateways import PersonGateway
from intranet.trip.src.db.gateways.base import RecordNotFound
from intranet.trip.src.models import User


async def get_user_by_uid(request, uid) -> Optional[User]:
    """
    Get user (person) from trip DB
    """
    acquire_kwargs = {'read_only': True} if settings.ENABLE_PYSCOPG2 else {}
    async with request.app.state.db.acquire(**acquire_kwargs) as conn:
        try:
            user = await PersonGateway(conn).get_user_by_uid(uid)
        except RecordNotFound:
            return None
    return user
