from datetime import date
from decimal import Decimal

from pydantic import BaseModel, UUID4, root_validator

from intranet.trip.src import enums
from intranet.trip.src.models.person import Person


class TransactionActions(BaseModel):
    update: bool
    delete: bool


class Transaction(BaseModel):
    transaction_id: UUID4
    company_id: int
    service_id: int = None
    trip_id: int
    service_type: enums.TransactionServiceType
    general_service_id: str = None
    person: Person
    status: enums.TransactionStatus
    type: enums.TransactionType
    original_transaction_id: UUID4 = None
    author_id: int = None
    execution_date: date
    invoice_date: date = None
    price: Decimal
    provider_fee: Decimal
    yandex_fee: Decimal
    currency: enums.CurrencyType
    is_penalty: bool

    is_obsolete: bool

    actions: TransactionActions = None
    editable_fields: set[str] = None
    fee: Decimal
    full_price: Decimal

    @root_validator(pre=True)
    def calculate_fee(cls, values):
        if values['provider_fee'] and values['yandex_fee']:
            values['fee'] = values['provider_fee'] + values['yandex_fee']
        return values

    @root_validator(pre=True)
    def calculate_full_price(cls, values):
        if values['provider_fee'] and values['yandex_fee'] and values['price']:
            values['full_price'] = values['price'] + values['provider_fee'] + values['yandex_fee']
        return values


class Deposit(BaseModel):
    deposit_id: UUID4
    charge_date: date
    company_id: int
    amount: Decimal
    author_id: int
