from datetime import date
from pydantic import BaseModel

from intranet.trip.src import enums


class DocumentBase(BaseModel):
    document_id: int
    document_type: enums.DocumentType = None
    first_name: str = None
    last_name: str = None
    middle_name: str = None
    citizenship: enums.Citizenship = enums.Citizenship.RU
    series: str = None
    number: str = None
    issued_by: str = None
    issued_on: date = None
    expires_on: date = None
    description: str = None
    external_document_id: str = None
    provider_document_id: int = None

    @property
    def is_russian_passport(self):
        return (
            self.document_type == enums.DocumentType.passport
            and self.citizenship == enums.Citizenship.RU
        )

    @property
    def is_foreign_passport(self):
        return self.document_type == enums.DocumentType.external_passport or (
            self.document_type == enums.DocumentType.passport
            and self.citizenship != enums.Citizenship.RU
        )


class Document(DocumentBase):
    person_id: int


class ExtPersonDocument(DocumentBase):
    ext_person_id: int


class BonusCardBase(BaseModel):
    bonus_card_id: int
    number: str
    service_provider_type: enums.ServiceType
    service_provider_code: str
    name: str
    name_en: str


class BonusCard(BonusCardBase):
    person_id: int


class ExtPersonBonusCard(BonusCardBase):
    ext_person_id: int
