from datetime import datetime
from fastapi import Query
from pydantic import BaseModel
from pydantic.dataclasses import dataclass

from intranet.trip.src.enums import EmployeeStatus


@dataclass
class EmployeeFilter:
    """Фильтр сотрудников в кабинете"""
    is_coordinator: bool = Query(None)
    statuses: list[EmployeeStatus] = Query(None)


class EmployeeActions(BaseModel):
    activate: bool = False
    reject: bool = False
    block: bool = False
    restore: bool = False
    grant_coordinator: bool = False
    revoke_coordinator: bool = False
    change_approver: bool = False


class Approver(BaseModel):
    approver_id: int
    first_name: str
    last_name: str
    middle_name: str | None


class Employee(BaseModel):
    employee_id: int
    company_id: int
    first_name: str
    last_name: str
    middle_name: str | None
    email: str
    is_active: bool
    is_dismissed: bool
    is_coordinator: bool
    rejected_at: datetime = None
    approver: Approver | None
    actions: EmployeeActions | None
