from typing import TYPE_CHECKING

from pydantic import BaseModel

from intranet.trip.src.enums import ServiceStatus, ServiceType
from intranet.trip.src.models.person import Person

if TYPE_CHECKING:
    from person_trip import PersonTrip


class ServiceActions(BaseModel):
    add_document: bool
    change_document: bool
    remove_document: bool
    reserve: bool
    update: bool
    delete: bool


class Service(BaseModel):
    service_id: int
    trip_id: int
    person_id: int
    person: Person = None
    type: ServiceType
    status: ServiceStatus
    ordering: int = 0
    boarding_pass: str = None
    is_broken: bool = None
    is_from_provider: bool = None
    is_authorized: bool
    document_id: int = None
    provider_service_id: int = None
    provider_order_id: int = None
    provider_document_id: int = None
    provider_bonus_card_id: int = None
    actions: ServiceActions = None

    trip_author_id: int = None
    seat_number: int = None
    is_person_trip_approved: bool = None
    in_process_of_cancelling: bool = False

    person_trip: 'PersonTrip' = None


class ServiceProvider(BaseModel):
    service_type: ServiceType
    code: str
    name: str
    name_en: str
