from arq import create_pool
from arq.connections import RedisSettings

from intranet.trip.src.config import settings


def get_redis_settings():
    sentinel_host = [(h, settings.REDIS_PORT) for h in settings.REDIS_HOST.split(',')]
    return RedisSettings(
        host=sentinel_host,
        sentinel=True,
        sentinel_master=settings.REDIS_SENTINEL_MASTER,
        password=settings.REDIS_PASSWORD,
    )


async def create_redis_pool():
    return await create_pool(
        settings_=get_redis_settings(),
        default_queue_name=settings.REDIS_QUEUE_NAME,
    )
