from fastapi import APIRouter

from intranet.trip.src.api.endpoints import (
    aeroclub,
    aviacenter,
    billing,
    bot,
    callbacks,
    employees,
    idm,
    isearch,
    meta,
    monitoring,
    notifications,
    ok,
    persons,
    provider,
    purposes,
    registries,
    services,
    token,
    trips,
    travel,
)
from intranet.trip.src.config import settings


api_router = APIRouter()
if settings.IS_YA_TEAM:
    api_router.include_router(idm.router, prefix='/idm', tags=['idm'])
    api_router.include_router(aviacenter.router, prefix='/aviacenter', tags=['aviacenter'])
    api_router.include_router(bot.router, prefix='/bot', tags=['bot'])
    api_router.include_router(callbacks.router, prefix='/callbacks', tags=['callbacks'])
    api_router.include_router(monitoring.router, prefix='/monitoring', tags=['monitoring'])
    api_router.include_router(notifications.router, prefix='/notifications', tags=['notifications'])
    api_router.include_router(ok.router, prefix='/ok', tags=['ok'])
    api_router.include_router(registries.router, prefix='/registries', tags=['registries'])

api_router.include_router(aeroclub.router, prefix='/aeroclub', tags=['aeroclub'])
api_router.include_router(billing.router, prefix='/billing', tags=['billing'])
api_router.include_router(employees.router, prefix='/companies', tags=['companies'])
api_router.include_router(isearch.router, prefix='/isearch', tags=['isearch'])
api_router.include_router(meta.router, prefix='/meta', tags=['meta'])
api_router.include_router(persons.router, prefix='/persons', tags=['persons'])
api_router.include_router(provider.router, prefix='/provider', tags=['provider'])
api_router.include_router(purposes.router, prefix='/purposes', tags=['purposes'])
api_router.include_router(services.router, prefix='/services', tags=['services'])
api_router.include_router(token.router, prefix='/csrf_token', tags=['token'])
api_router.include_router(trips.router, prefix='/trips', tags=['trips'])
api_router.include_router(travel.router, prefix='/travel', tags=['travel'])
