PY3_LIBRARY(trip)

OWNER(g:tools-trip)

PEERDIR(
    contrib/python/aioboto3
    contrib/python/aiofiles
    contrib/python/aiohttp
    contrib/python/aiopg
    contrib/python/aioredis-lock
    contrib/python/arq
    contrib/python/asgiref
    contrib/python/asyncssh
    contrib/python/pytz
    contrib/python/fastapi
    contrib/python/hypercorn
    contrib/python/sqlalchemy/sqlalchemy-1.4
    contrib/python/ipython
    contrib/python/xmltodict
    contrib/python/Jinja2
    contrib/python/ipdb  # пусть временно, уберу если не забуду
    contrib/python/python-multipart
    contrib/python/transliterate
    contrib/python/phonenumbers
    contrib/python/cached-property
    contrib/python/sentry-sdk

    # модуль sentry_sdk.integrations.asgi сейчас собирается только внутри модуля django
    # https://a.yandex-team.ru/arc/trunk/arcadia/contrib/python/sentry-sdk/ya.make?rev=r8429819#L34
    contrib/python/sentry-sdk/sentry_sdk/integrations/django

    library/python/blackbox
    library/python/resource
    library/python/tvm2
    library/python/async_clients
    library/python/errorboosterclient
    library/python/ylog
    library/python/pyscopg2
    library/python/awssdk_async_extensions/lib

    kikimr/public/sdk/python/persqueue

    intranet/trip/lib/arq_utils
    intranet/trip/lib/asgi_log_middleware
    intranet/library/fastapi_csrf/src

    yt/python/client
)

PY_SRCS(
    __init__.py
    cache.py
    error_booster.py
    enums.py
    exceptions.py
    ipython_startup.py
    logging.py
    main.py
    manage.py
    redis.py
    unit_of_work.py

    api/__init__.py
    api/decorators.py
    api/depends.py

    api/auth/__init__.py
    api/auth/blackbox.py
    api/auth/oauth.py
    api/auth/permissions.py
    api/auth/tvm.py

    api/converters/__init__.py
    api/converters/aeroclub.py
    api/converters/base.py

    api/endpoints/__init__.py
    api/endpoints/aeroclub.py
    api/endpoints/aviacenter.py
    api/endpoints/billing.py
    api/endpoints/bot.py
    api/endpoints/callbacks.py
    api/endpoints/employees.py
    api/endpoints/meta.py
    api/endpoints/monitoring.py
    api/endpoints/notifications.py
    api/endpoints/ok.py
    api/endpoints/idm.py
    api/endpoints/isearch.py
    api/endpoints/persons.py
    api/endpoints/purposes.py
    api/endpoints/registries.py
    api/endpoints/services.py
    api/endpoints/token.py
    api/endpoints/trips.py
    api/endpoints/travel.py
    api/endpoints/provider/__init__.py
    api/endpoints/provider/search.py
    api/endpoints/provider/suggest.py

    api/schemas/__init__.py
    api/schemas/billing.py
    api/schemas/common.py
    api/schemas/document.py
    api/schemas/employee.py
    api/schemas/notification.py
    api/schemas/ok.py
    api/schemas/person.py
    api/schemas/person_trip.py
    api/schemas/purpose.py
    api/schemas/service.py
    api/schemas/staff.py
    api/schemas/trip.py
    api/schemas/user.py
    api/schemas/travel.py
    api/schemas/provider/__init__.py
    api/schemas/provider/search.py
    api/schemas/provider/search_filter.py
    api/schemas/provider/suggest.py
    api/schemas/validators/__init__.py
    api/schemas/validators/db_validate_by_ids.py
    api/schemas/validators/document_person_name_validate.py

    config/__init__.py
    config/default.py
    config/development.py
    config/testing.py
    config/production.py

    db/__init__.py
    db/gateways/__init__.py
    db/gateways/base.py
    db/gateways/billing.py
    db/gateways/document.py
    db/gateways/employee.py
    db/gateways/holding.py
    db/gateways/person.py
    db/gateways/person_trip.py
    db/gateways/purpose.py
    db/gateways/registry.py
    db/gateways/service.py
    db/gateways/company.py
    db/gateways/trip.py
    db/subqueries/common.py
    db/subqueries/trip.py
    db/subqueries/person.py
    db/tables.py
    db/utils.py
    db/staff_document_migration.py

    lib/hub/__init__.py
    lib/hub/api.py
    lib/hub/enums.py
    lib/hub/models.py
    lib/hub/sync.py

    lib/aeroclub/__init__.py
    lib/aeroclub/api.py
    lib/aeroclub/enums.py
    lib/aeroclub/exceptions.py
    lib/aeroclub/models/__init__.py
    lib/aeroclub/models/common.py
    lib/aeroclub/models/custom_properties.py
    lib/aeroclub/models/document.py
    lib/aeroclub/models/profile.py
    lib/aeroclub/models/reference.py
    lib/aeroclub/models/search_filter.py
    lib/aeroclub/models/search_request.py
    lib/aeroclub/models/search_result.py
    lib/aeroclub/models/service.py
    lib/aeroclub/models/trip.py
    lib/aeroclub/notifications/__init__.py
    lib/aeroclub/notifications/base.py
    lib/aeroclub/notifications/handlers.py

    lib/aviacenter/__init__.py
    lib/aviacenter/api.py
    lib/aviacenter/config.py
    lib/aviacenter/enums.py
    lib/aviacenter/exceptions.py
    lib/aviacenter/fields.py
    lib/aviacenter/models/__init__.py
    lib/aviacenter/models/avia_booking.py
    lib/aviacenter/models/hotel_booking.py
    lib/aviacenter/models/search_request.py
    lib/aviacenter/models/train_booking.py

    lib/drive/__init__.py
    lib/drive/api.py
    lib/drive/enums.py
    lib/drive/gateway.py

    lib/messenger/__init__.py
    lib/messenger/api.py
    lib/messenger/gateway.py
    lib/messenger/notifications.py
    lib/messenger/sync.py

    lib/ok/__init__.py
    lib/ok/api.py
    lib/ok/exceptions.py

    lib/passport/__init__.py
    lib/passport/api.py
    lib/passport/exceptions.py
    lib/passport/gateway.py
    lib/passport/models.py

    lib/provider/__init__.py
    lib/provider/client.py

    lib/registry/__init__.py
    lib/registry/base.py

    lib/samsara/__init__.py
    lib/samsara/api.py
    lib/samsara/exceptions.py
    lib/samsara/models.py

    lib/sftp_client/__init__.py
    lib/sftp_client/api.py
    lib/sftp_client/exceptions.py
    lib/sftp_client/sync.py

    lib/staff/__init__.py
    lib/staff/api.py
    lib/staff/converters.py
    lib/staff/gateway.py
    lib/staff/sync.py
    lib/staffapi/__init__.py
    lib/staffapi/api.py
    lib/staffapi/gateway.py
    lib/staffapi/sync.py

    lib/tracker/api.py
    lib/tracker/notifications.py

    lib/translit/ru_icao.py

    lib/isearch/__init__.py
    lib/isearch/api.py

    lib/travel/__init__.py
    lib/travel/api.py
    lib/travel/exceptions.py

    lib/yt/__init__.py
    lib/yt/api.py
    lib/yt/dataclasses.py
    lib/yt/exceptions.py
    lib/yt/gateway.py

    lib/mds/__init__.py
    lib/mds/s3_api.py
    lib/mds/s3_trip.py

    lib/utils.py

    lib/xml_parser/__init__.py
    lib/xml_parser/api.py
    lib/xml_parser/exceptions.py
    lib/xml_parser/providers.py

    models/__init__.py
    models/billing.py
    models/common.py
    models/document.py
    models/employee.py
    models/full.py
    models/person.py
    models/person_trip.py
    models/purpose.py
    models/registry.py
    models/service.py
    models/trip.py

    logic/base.py
    logic/aeroclub/custom_properties.py
    logic/aeroclub/documents.py
    logic/aeroclub/reference.py
    logic/aeroclub/services.py
    logic/aeroclub/trips.py
    logic/providers/__init__.py
    logic/providers/converters.py
    logic/providers/factory.py
    logic/providers/gateway.py
    logic/providers/aeroclub/__init__.py
    logic/providers/aeroclub/gateway.py
    logic/providers/aeroclub/converters/__init__.py
    logic/providers/aeroclub/converters/search.py
    logic/providers/aeroclub/converters/suggest.py
    logic/providers/aviacenter/__init__.py
    logic/providers/aviacenter/examples.py
    logic/providers/aviacenter/gateway.py
    logic/providers/aviacenter/converters/__init__.py
    logic/providers/aviacenter/converters/search.py
    logic/providers/aviacenter/converters/suggest.py
    logic/triggers/__init__.py
    logic/triggers/base.py
    logic/triggers/drive.py
    logic/triggers/executor.py
    logic/bot.py
    logic/billing.py
    logic/ext_persons.py
    logic/employees.py
    logic/messenger.py
    logic/monitoring.py
    logic/notifications.py
    logic/ok.py
    logic/persons.py
    logic/person_trips.py
    logic/services.py
    logic/tracker.py
    logic/trips.py

    middlewares/__init__.py
    middlewares/auth.py
    middlewares/exceptions.py
    middlewares/utils.py

    router/__init__.py
    router/external.py
    router/internal.py

    worker/__init__.py
    worker/periodic_tasks.py
    worker/settings.py
    worker/tasks.py
)

RESOURCE_FILES(
    PREFIX intranet/trip/src/

    lib/hub/template.xml
    lib/messenger/start_message.jinja2

    templates/messenger/need_to_reserve_rail.jinja2

    templates/tracker/cancel_person_trip.jinja2
    templates/tracker/change_conf_role.jinja2
    templates/tracker/need_to_check_services.jinja2
    templates/tracker/need_to_reserve_rail.jinja2
    templates/tracker/notification_messenger.jinja2
    templates/tracker/overprice_service.jinja2
    templates/tracker/person_trip_belarus_created.jinja2
    templates/tracker/person_trip_created.jinja2
    templates/tracker/person_trip_offline_created.jinja2
    templates/tracker/service_broken.jinja2
    templates/tracker/service_rejected.jinja2
    templates/tracker/service_unavailable.jinja2
    templates/tracker/trip_service_deleted.jinja2
    templates/tracker/trip_service_executed.jinja2
    templates/tracker/trip_services_executed.jinja2
    templates/tracker/speaker_details_updated.jinja2
    templates/tracker/conference_bribe_warning.jinja2
)

NO_CHECK_IMPORTS()

END()
