OWNER(g:tools-trip)

PY3TEST()

SIZE(MEDIUM)

INCLUDE(${ARCADIA_ROOT}/antiadblock/postgres_local/recipe/recipe.inc)
INCLUDE(${ARCADIA_ROOT}/mapreduce/yt/python/recipe/recipe.inc)

ENV(ENV_TYPE=development)

DEPENDS(
    antiadblock/postgres_local/recipe
    intranet/trip/alembic
)

PEERDIR(
    intranet/trip/lib/arq_utils
    intranet/trip/lib/asgi_log_middleware
    intranet/trip/src

    contrib/python/mock
    contrib/python/vcrpy
    contrib/python/pytest-asyncio
    contrib/python/httpx
)

TEST_SRCS(
    api/test_billing.py
    api/test_bonus_cards.py
    api/test_employees.py
    api/test_idm.py
    api/test_meta.py
    api/test_monitoring.py
    api/test_permissions.py
    api/test_person_trip_schema.py
    api/test_person_trip_services.py
    api/test_persons.py
    api/test_purposes.py
    api/test_provider_search.py
    api/test_schemas.py
    api/test_services.py
    api/test_trips.py

    core/test_middlewares.py
    core/test_unit_of_work.py

    db/gateways/test_company_gateway.py
    db/gateways/test_person_gateway.py
    db/gateways/test_person_trip_gateway.py
    db/gateways/test_trip_gateway.py

    lib/aviacenter/test_client.py

    lib/passport/test_api.py
    lib/passport/test_gateway.py

    lib/staff/test_convertion_to_staff.py
    lib/staff/test_convertion_trip_from_staff.py
    lib/staff/test_staff_gateway.py
    lib/staff/test_staff_pull.py

    lib/yt/test_api.py
    lib/yt/test_gateway.py

    lib/test_drive_gateway.py
    lib/test_hub_profile_sync.py
    lib/test_registry.py
    lib/test_translit_icao.py
    lib/test_utils.py
    lib/test_xml_parser.py

    logic/aeroclub/test_documents.py
    logic/aeroclub/test_documents_sync.py
    logic/aeroclub/test_service_wrapper.py
    logic/aeroclub/test_services_executor.py
    logic/aeroclub/test_reference.py
    logic/ext_persons/test_ext_persons.py
    logic/person_trips/test_cancel_action.py
    logic/person_trips/test_create_service_action.py
    logic/person_trips/test_execute_extra_services_action.py
    logic/person_trips/test_execute_services_action.py
    logic/person_trips/test_search_service_action.py
    logic/providers/aeroclub/data.py
    logic/providers/aeroclub/test_aeroclub_converters.py
    logic/providers/aviacenter/data.py
    logic/providers/aviacenter/test_aviacenter_converters.py
    logic/test_custom_properties.py
    logic/test_documents.py
    logic/test_monitoring.py
    logic/test_notifications.py
    logic/test_ok.py
    logic/test_persons.py
    logic/test_person_trips.py
    logic/test_services.py
    logic/test_search.py
    logic/test_trips.py
    logic/test_drive_trigger.py

    templates/test_person_trip_created.py

    conftest.py
    factories.py
    mocks.py
    helpers.py
)

NO_CHECK_IMPORTS()

END()
