FROM registry.yandex.net/vins/base:1.3

WORKDIR /app

RUN locale-gen en_US en_US.UTF-8 ru_RU.UTF-8 && dpkg-reconfigure locales

COPY deps/apt.txt /
RUN apt-get update -qq \
    && cat /apt.txt | xargs apt-get install -y \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/* \
    && rm /apt.txt

RUN apt-get update \
    && apt-get install software-properties-common -y \
    && apt-add-repository ppa:mc3man/trusty-media -y \
    && apt-get update \
    && apt-get install ffmpeg gstreamer0.10-ffmpeg -y \
    && pip install --upgrade pip

COPY deps/install-vins.sh /
RUN /install-vins.sh && rm /install-vins.sh

COPY deps/python-main.txt /
RUN pip install -i https://pypi.yandex-team.ru/simple/ -r /python-main.txt \
    && rm /python-main.txt

COPY setup.py setup.py
