# coding: utf-8

from django.conf import settings
from django.contrib import admin
from django.core.exceptions import PermissionDenied

from waffle.models import Switch

from uhura import models


class CustomAdminSite(admin.AdminSite):
    def has_permission(self, request):
        host = request.get_host().split(':')[0]
        if any([host.endswith(x) for x in settings.DJANGO_ADMIN_ALLOWED_HOSTS]):
            return super(CustomAdminSite, self).has_permission(request)
        else:
            raise PermissionDenied()


class ReadOnlyModelAdmin(admin.ModelAdmin):
    def has_add_permission(self, request):
        return False

    def has_delete_permission(self, request, obj=None):
        return False

    def get_actions(self, request):
        actions = super(ReadOnlyModelAdmin, self).get_actions(request)
        if 'delete_selected' in actions:
            del actions['delete_selected']
        return actions


class UserAdmin(admin.ModelAdmin):
    search_fields = ['uid']


admin_site = CustomAdminSite()
admin_site.register(models.EmergencyNotifier, admin.ModelAdmin)
admin_site.register(models.EmergencyTestingList, admin.ModelAdmin)
admin_site.register(models.EmergencyNotification, ReadOnlyModelAdmin)
admin_site.register(models.Office, admin.ModelAdmin)
admin_site.register(models.Subscription, admin.ModelAdmin)
admin_site.register(models.User, UserAdmin)
admin_site.register(Switch, admin.ModelAdmin)
