# coding: utf-8
from __future__ import absolute_import, unicode_literals

from vins_core.nlu.flow_nlu import FlowNLU  # noqa: E402


def compute_posteriors(likelihoods, session, intent_infos, transition_model, req_info=None, normalize=True):
    posteriors = {}
    for intent_name in intent_infos:
        score = likelihoods[intent_name] * intent_infos[intent_name].prior
        if transition_model:
            score = transition_model(intent_name, session, req_info, base_score=score)
        posteriors[intent_name] = score
    total_score = sum(posteriors.itervalues())
    for intent in posteriors:
        posteriors[intent] /= total_score
    return posteriors

FlowNLU.compute_posteriors = staticmethod(compute_posteriors)
