# coding: utf-8

import os
import time
import locale


def setup_environment():
    os.environ['YENV_NAME'] = 'intranet'

    # Environments names should be like
    # [blah-blah-blah-]telegram-testing
    if 'QLOUD_ENVIRONMENT' in os.environ:
        sp = os.environ['QLOUD_ENVIRONMENT'].split('-')
        (bot_type, env_type) = sp[-2:]
        os.environ['BOT_TYPE'] = bot_type
        os.environ['YENV_TYPE'] = env_type
    # Stages names should be like
    # tools_uhura-telegram_production
    elif 'DEPLOY_STAGE_ID' in os.environ:
        stage = os.environ['DEPLOY_STAGE_ID']
        os.environ['BOT_TYPE'] = stage.split('-')[-1].split('_')[0]
        os.environ['YENV_TYPE'] = 'production' if stage.endswith('production') else 'testing'
    else:
        if 'BOT_TYPE' not in os.environ:
            os.environ['BOT_TYPE'] = 'telegram'
        os.environ['YENV_TYPE'] = 'development'

    locale.setlocale(locale.LC_TIME, 'ru_RU.UTF-8'.encode('utf-8'))

    os.environ['TZ'] = 'Europe/Moscow'
    time.tzset()
