# coding: utf-8

from __future__ import unicode_literals

from django.conf import settings

from uhura.external import intranet
from uhura.lib import cache_storage


@cache_storage.memoize_decorator(fresh_time=settings.PASSWORD_CACHE_FRESH_TIME)
def get_mobcert_password():
    return intranet.get_request(settings.MOBCERT_URL)['result']['wifi']['password']


@cache_storage.memoize_decorator(fresh_time=settings.PASSWORD_CACHE_FRESH_TIME)
def get_wifi_password():
    return intranet.get_request(settings.GUEST_WIFI_URL)['result']['wifi']['password']
