# coding: utf-8

import logging
import os
import requests


TRACK_URL = 'https://api.botan.io/track'
logger = logging.getLogger(__name__)


class Botan:
    def __init__(self, token):
        if not token:
            logger.warning('Botan is disabled beacause BOTAN_TOKEN variable is not set')
        self.token = token

    def track(self, uid, message, name):
        if self.token:
            try:
                r = requests.post(
                    TRACK_URL,
                    params={
                        'token': self.token,
                        'uid': uid,
                        'name': name
                    },
                    json=message,
                    headers={
                        'Content-type': 'application/json'
                    },
                    timeout=0.2
                )
                r.raise_for_status()
                logger.debug('Successful botan track')
            except Exception as e:
                logger.error('Botan error [%s]', e)


botan_token = os.environ.get('BOTAN_TOKEN')
botan = Botan(botan_token)
