# coding: utf-8

from __future__ import unicode_literals

import os
import urllib

import easywebdav

from ids.utils import https as ids_https

from django.conf import settings


class JingClient:
    def __init__(self, host, username, password, protocol='https'):
        ca_bundle_path = ids_https.get_ca_bundle_path()
        verify = ca_bundle_path or False
        self._webdav = easywebdav.connect(
            host, username=username, password=password, protocol=protocol, verify_ssl=verify
        )

    def upload(self, file_name, login='uhura'):
        remote_path = os.path.join(login, file_name).encode('utf-8')
        self._webdav.upload(file_name, remote_path)
        return 'https://{}/files/{}/{}'.format(
            settings.JING_HOST.replace('dav', ''), login, urllib.quote(file_name.encode('utf-8'))
        )


jing = JingClient(settings.JING_HOST, username='jing', password='jing', protocol='https')
