# coding: utf-8

from __future__ import unicode_literals

from datetime import datetime
import os
import urlparse

from django.conf import settings
import ghostscript

from uhura.external import calendar
from uhura.external import intranet


MOROZOV_MENU_TYPES = ['zavtrak', 'obed', 'bzhu']
BENUA_MENU_TYPES = ['obed', 'uzhin']


def get_canteen_menu_url(date, office, menu_type):
    if office == 'benua':
        base_url = settings.BENUA_CANTEEN_MENU_URL
        implemented_menu_types = BENUA_MENU_TYPES
    else:
        base_url = settings.MOROZOV_CANTEEN_MENU_URL
        implemented_menu_types = MOROZOV_MENU_TYPES

    if menu_type not in implemented_menu_types:
        menu_type = 'obed'

    response = intranet.get_request(base_url)
    if response is None:
        return None
    res_date = date.replace(hour=0, minute=0, second=1, microsecond=0)
    if menu_type == 'zavtrak':
        res_date = calendar.prev_working_day(res_date)

    if menu_type == 'obed':
        extra_menu_types = ['bzhu']
    else:
        extra_menu_types = []

    res_url = None
    for item in response['data']['data']:
        date_string = item['upload_date']
        url = item['url']
        cur_date = datetime.strptime(date_string.split('.')[0], '%Y-%m-%dT%H:%M:%S')
        if res_date < cur_date and menu_type in url and all([x not in url for x in extra_menu_types]):
            res_date = cur_date
            res_url = url
    return urlparse.urljoin(base_url + '/', res_url.split('/')[-1]) if res_url else None


def download_canteen_menu(date, office, menu_type):
    # we do not cache menu because it caches through telegram image caching
    url = get_canteen_menu_url(date, office, menu_type)
    if url is None:
        return None
    jpeg_filename = url.split('/')[-1].split('.')[0] + '.jpeg'
    if not os.path.exists(jpeg_filename):
        pdf_filename = jpeg_filename.split('.')[0] + '.pdf'
        response = intranet.get_request(url, raw_response=True)
        with open(pdf_filename, 'wb') as f:
            f.write(response)
        try:
            _ghostscript_run(jpeg_filename, pdf_filename)
        except ghostscript._gsprint.GhostscriptError:
            jpeg_filename = None
        os.remove(pdf_filename)
    return jpeg_filename


def _ghostscript_run(jpeg_filename, pdf_filename):
    args = '''gs -dBATCH -dNOPAUSE -dSAFER -sDEVICE=jpeg -dJPEGQ=95 -r300x300 -dPDFFitPage -dFIXEDMEDIA
            -sDEFAULTPAPERSIZE=a4 -sOutputFile=%s %s''' % (jpeg_filename, pdf_filename)
    args = [arg.encode('utf-8') for arg in args.split()]
    ghostscript.Ghostscript(*args)


def get_wiki_grid(grid_id):
    url = settings.WIKI_GRID_URL_TEMPLATE % grid_id
    grid_data = intranet.get_request(url)
    if grid_data is None:
        return None
    return grid_data['data']
