from django.conf import settings

from uhura.external import intranet


def get_car_numbers_from_image(image_filename):
    with open(image_filename, 'rb') as f:
        data = f.read()
    result = intranet.post_request(settings.YAVISION_URL, data=data, raw=True)
    if result is None:
        return None
    pre_result = [(obj['confidence'], obj['recognition']['text']) for obj in result]
    pre_result.sort()
    return [x[1] for x in pre_result]
