# coding: utf-8
from __future__ import unicode_literals

import logging

from django_idm_api.exceptions import RoleNotFound, UserNotFound
from django_idm_api.hooks import BaseHooks

from uhura.idm.streams import RoleStream
from uhura.models import User

logger = logging.getLogger(__name__)


class Hooks(BaseHooks):
    GET_ROLES_STREAMS = [RoleStream]

    def add_role_impl(self, login, role_data, fields, **kwargs):
        role = role_data['role']
        if role != 'can_use_uhura':
            raise RoleNotFound(role)

        logger.info('Adding role %s for %s', role, login)
        try:
            user = User.objects.get(username=login)
        except User.DoesNotExist:
            raise UserNotFound(login)

        user.can_use_uhura = True
        user.save(update_fields=['can_use_uhura'])

    def remove_role_impl(self, login, role_data, data, is_fired, **kwargs):
        role = role_data['role']
        if role != 'can_use_uhura':
            raise RoleNotFound(role)

        logger.info('Removing role %s for %s', role, login)
        try:
            user = User.objects.get(username=login)
        except User.DoesNotExist:
            raise UserNotFound(login)

        user.can_use_uhura = False
        user.save(update_fields=['can_use_uhura'])

    def info_impl(self, **kwargs):
        roles = {'can_use_uhura': 'Пользователь Ухуры'}
        return roles
