# coding: utf-8

from django_idm_api.hooks import RoleStream as BaseRoleStream

from uhura.models import User


class RoleStream(BaseRoleStream):
    def get_queryset(self):
        return User.objects.filter(can_use_uhura=True).order_by('pk')

    def values_list(self, queryset):
        return queryset.values_list('pk', 'username')

    def row_as_dict(self, row):
        pk, username = row
        return {
            'login': username,
            'path': '/role/can_use_uhura/',
        }
