import logging

from django.core.mail import EmailMultiAlternatives

from jinja2 import Environment, FileSystemLoader

import yenv

from vins_core.nlg.filters import inflect

from uhura import settings


logger = logging.getLogger(__name__)


def send_mail(_from, to, subject, template_name=None, template=None, context=None, text=None, use_bcc=True):
    if template_name is None and template is None and text is None:
        raise ValueError('template_name or template or text must be not None')
    if context is None:
        context = {}
    logger.info(
        'Send mail. Template: %s, To: %s, From: %s, Context: %s', (template_name or template), to, _from, context
    )
    if not isinstance(to, list):
        to = [to]
    if not isinstance(_from, list):
        _from = [_from]
    if yenv.type != 'production':
        subject = '[%s] %s' % (yenv.type.upper(), subject)

    env = Environment(loader=FileSystemLoader(settings.TEMPLATES_PATH))
    env.filters['inflect'] = inflect
    if template_name:
        html_template = env.get_template(template_name + '.html')
        text_template = env.get_template(template_name + '.txt')
    elif template:
        html_template = text_template = env.from_string(template)

    if template_name or template:
        html_content = html_template.render(context)
        text_content = text_template.render(context)
    else:
        html_content = text_content = text

    bcc = [settings.UHURA_BCC_MAIL] if use_bcc else None

    message = EmailMultiAlternatives(
        subject=subject,
        body=text_content,
        from_email=settings.MAIL_FROM,
        to=to,
        reply_to=_from,
        bcc=bcc
    )
    if template_name:
        message.attach_alternative(html_content, 'text/html')
    message.send()
