# coding: utf-8

from __future__ import unicode_literals

from datetime import datetime

from django.conf import settings
import os
import telegram

from uhura.lib import cache_storage


def send_photo(chat_id, path):
    file_type = 'photo'
    bot = telegram.Bot(settings.TELEGRAM_TOKEN)
    kwargs = {
        'chat_id': chat_id,
        file_type: open(path.encode('utf-8'), 'rb')
    }
    message_obj = bot.send_photo(**kwargs)
    file_obj = message_obj.photo
    if isinstance(file_obj, list):
        file_obj = file_obj[0]
    return file_obj.file_id


def load_canteen_queue_to_messengers():
    try:
        queue_file_id = send_photo(
            settings.TASHA_CHAT_ID,
            os.path.join(settings.FILE_CACHE_PATH, settings.CANTEEN_QUEUE_CACHE_FILE),
        )
    except Exception:
        pass
    else:
        cache_storage.set(
            settings.CANTEEN_QUEUE_CACHE_KEY,
            {
                'file_id': queue_file_id,
                'file_timestamp': datetime.now().strftime('%H:%M'),
            },
            None
        )


if __name__ == '__main__':
    load_canteen_queue_to_messengers()
