# coding: utf-8

from __future__ import unicode_literals

import urlparse

from django.conf import settings

from uhura.external import intranet
from uhura.external.intranet import get_request
from uhura.utils.tvm import get_tvm_service_headers

TELEGRAM_MAX_CHATS = 1000
TASHA_TIMEOUT = 10
INVITE_TO_CHAT_TIMEOUT = 30


def _get_max_free_bot_username():
    result = get_request(
        urlparse.urljoin(settings.TASHA_API_HOST, settings.TASHA_BOTS_PATH),
        headers=get_tvm_service_headers(settings.TVM2_TASHA_ID),
    )
    if not result:
        raise ValueError('Chats slots overflow')
    return result


def create_chat(title, telegram_id, telegram_username):
    try:
        max_free_bot_username_generator = _get_max_free_bot_username()
    except ValueError:
        return None
    for max_free_bot_username in max_free_bot_username_generator:
        host = settings.TASHA_API_HOST
        uri = '/%s/telegram/createchat/' % max_free_bot_username.lower()
        url = urlparse.urljoin(host, uri)
        data = {
            'title': title,
            'telegram_id': telegram_id,
            'telegram_username': telegram_username,
        }
        result = intranet.post_request(
            url,
            data=data,
            timeout=TASHA_TIMEOUT,
            headers=get_tvm_service_headers(settings.TVM2_TASHA_ID),
        )
        if result is not None:
            return result


def invite_to_chat_by_link(link):
    try:
        max_free_bot_username_generator = _get_max_free_bot_username()
    except ValueError:
        raise ValueError('failed to add any of bots')
    for max_free_bot_username in max_free_bot_username_generator:
        host = settings.TASHA_API_HOST
        uri = '/%s/telegram/invitetochat/' % max_free_bot_username.lower()
        url = urlparse.urljoin(host, uri)
        data = {'invite_link': link}
        result = intranet.post_request(
            url,
            data=data,
            timeout=INVITE_TO_CHAT_TIMEOUT,
            headers=get_tvm_service_headers(settings.TVM2_TASHA_ID),
        )
        if result is not None:
            return (result['status'], max_free_bot_username)
    raise ValueError('failed to add any of bots')
