import logging

import attr

from vins_core.dm import response as vins_response

from uhura.utils import validate


logger = logging.getLogger(__name__)


@attr.s
class UhuraVinsResponse(vins_response.VinsResponse):
    vins_response_overrided = attr.ib(default=False)
    messages = attr.ib(default=attr.Factory(list))
    buttons = attr.ib(default=attr.Factory(list))
    images = attr.ib(default=attr.Factory(list))
    request_user_contact = attr.ib(default=False)
    forward_messages = attr.ib(default=attr.Factory(list))
    service_messages = attr.ib(default=attr.Factory(list))
    buttons_in_row_count = attr.ib(default=2)
    cancel_button = attr.ib(default=False)
    inline_keyboards = attr.ib(default=attr.Factory(list))

    def reply(self, messages=None, buttons=None, images=None, request_user_contact=False, forward_messages=None,
              service_messages=None, join_messages=False, buttons_in_row_count=2, cancel_button=False,
              inline_keyboards=None):
        logger.debug(
            'Reply with args: messages=%r, buttons=%r, images=%r, request_user_contact=%r, '
            'forward_messages=%r, service_messages=%r', messages, buttons, images, request_user_contact,
            forward_messages, service_messages
        )
        self.vins_response_overrided = True
        if not messages and not buttons and not images and not forward_messages and not service_messages:
            return
        if messages and not isinstance(messages, list):
            messages = [messages]
        if buttons and not isinstance(buttons, list):
            buttons = [buttons]
        if images and not isinstance(images, list):
            images = [images]
        if forward_messages and not validate.validate_list_of_lists_or_tuples(forward_messages):
            forward_messages = [forward_messages]
        if service_messages and not validate.validate_list_of_lists_or_tuples(service_messages):
            service_messages = [service_messages]

        if messages:
            self.messages.extend(messages)
        if buttons:
            self.buttons.extend(buttons)
        if images:
            self.images.extend(images)
        if forward_messages:
            self.forward_messages.extend(forward_messages)
        if service_messages:
            self.service_messages.extend(service_messages)

        self.inline_keyboards = inline_keyboards or []
        self.request_user_contact = request_user_contact
        self.join_messages = join_messages
        self.buttons_in_row_count = buttons_in_row_count
        self.cancel_button = cancel_button

    @classmethod
    def from_dict(cls, data):
        res = super(UhuraVinsResponse, cls).from_dict(data)
        res.messages = [m for m in data['messages']]
        res.buttons = [m for m in data['buttons']]
        res.images = [m for m in data['images']]
        res.forward_messages = [m for m in data['forward_messages']]
        res.service_messages = [m for m in data['service_messages']]
        res.request_user_contact = data['request_user_contact']
        res.vins_response_overrided = data['vins_response_overrided']
        res.join_messages = data.get('join_messages', False)
        res.inline_keyboards = data.get('inline_keyboards', [])
        return res
