# coding: utf-8

INTERNAL_INTENT_SEPARATOR = '__'


def parent_intent_name(intent_name):
    internal_separator_pos = intent_name.find(INTERNAL_INTENT_SEPARATOR)
    if internal_separator_pos != -1:
        return intent_name[:internal_separator_pos]
    else:
        return intent_name


def have_same_parent(intent_name, another_intent_name):
    return parent_intent_name(intent_name) == parent_intent_name(another_intent_name)


def is_internal(intent_name):
    return intent_name is not None and intent_name != parent_intent_name(intent_name)


def is_submit_form_intent(intent_name):
    return trim_name_prefix(intent_name).startswith('form_')


def get_intent_module(intent_name):
    return intent_name.split('.')[1]


def is_image_intent(intent_name):
    return 'image' in intent_name.split('.')[2]


def is_quest_intent(intent_name):
    return 'quest' in intent_name


def trim_name_prefix(intent_name):
    return intent_name.split('.')[-1]
