# coding: utf-8

from __future__ import unicode_literals

import logging
import os

from django.conf import settings
from django.core.management.base import BaseCommand
from uhura.lib.queue_cache import load_canteen_queue_to_messengers


logger = logging.getLogger(__name__)


class Command(BaseCommand):
    help = 'Take photo from canteen stream, upload photo to tg and cache file_id'

    def handle(self, *args, **options):
        path = os.path.join(settings.FILE_CACHE_PATH, settings.CANTEEN_QUEUE_CACHE_FILE)
        stream_path = settings.CANTEEN_STREAM_PATH
        cmd = (
            'bash -c "ffmpeg -y -i {stream_path} -ss 00:00:00.000 -vframes 1 {path}-tmp.jpg &> /dev/null && mv {path}-tmp.jpg {path}"'
        ).format(
            stream_path=stream_path,
            path=path,
        )
        exit_code = os.system(cmd)
        if exit_code != 0:
            logger.error('Can not get photo from canteen stream')
            return

        load_canteen_queue_to_messengers()
