# coding: utf-8

import logging
from time import sleep

from yql.api.v1.client import YqlClient
from yql.client.table_read import YqlSchemalessTableException


logger = logging.getLogger(__name__)
yql_client = YqlClient()


def start_query(query_text, retries=5):
    logger.info('Running query %s', query_text)
    query = yql_client.query(query_text, syntax_version=1)
    try:
        query.run()
    except Exception:
        logger.exception('YQL query failed')

        if retries > 0:
            logger.info('Retrying after 120 seconds')
            sleep(120)
            return start_query(query_text, retries - 1)
    else:
        return query


def table_exists(table_path, cluster='hahn'):
    try:
        yql_client.read_table(cluster=cluster, path=table_path).column_names
    except YqlSchemalessTableException:
        return False
    else:
        return True


def update_model(obj, fields):
    """Обновляет поля объекта obj в соответствии со словарем fields.
    Возвращает True, если хотя бы одно из полей изменилось"""
    changed_fields = []
    for key, value in fields.items():
        old_value = getattr(obj, key)

        if old_value != value:
            setattr(obj, key, value)
            changed_fields.append(key)
    if changed_fields:
        obj.save(update_fields=changed_fields)
    return bool(changed_fields)
