# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2018-03-05 09:35
from __future__ import unicode_literals

from django.db import migrations, models

from uhura.external import staff


def merge_UserPhoneAuth_and_UserProfile(apps, schema_editor):
    UserPhoneAuth = apps.get_model('uhura', 'UserPhoneAuth')
    UserProfile = apps.get_model('uhura', 'UserProfile')
    User = apps.get_model('uhura', 'User')

    for phone_object in UserPhoneAuth.objects.all():
        phone = phone_object.phone
        telegram_id = phone_object.user_id
        staff_data = staff.get_person_data_by_userphone(phone)
        if staff_data is not None:
            staff_id = staff_data['uid']
            User.objects.update_or_create(staff_id=staff_id, defaults={'phone': phone, 'telegram_id': telegram_id})

    for city_object in UserProfile.objects.all():
        city = city_object.city
        staff_id = city_object.user_id
        User.objects.update_or_create(staff_id=staff_id, defaults={'city': city})


class Migration(migrations.Migration):
    dependencies = [
        ('uhura', '0006_session_updated_at'),
    ]

    operations = [
        migrations.CreateModel(
            name='EmergencyNotifier',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('staff_login', models.CharField(max_length=255, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('staff_id', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('telegram_id', models.CharField(blank=True, default='', max_length=255, null=False, db_index=True)),
                ('yamb_id', models.CharField(blank=True, default='', max_length=255, null=False)),
                ('phone', models.CharField(blank=True, default='', max_length=20, null=False)),
                ('city', models.CharField(blank=True, default='', max_length=255, null=False)),
            ],
        ),
        migrations.RunPython(
            code=merge_UserPhoneAuth_and_UserProfile,
        ),
        migrations.DeleteModel(
            name='UserPhoneAuth',
        ),
        migrations.DeleteModel(
            name='UserProfile',
        ),
        migrations.CreateModel(
            name='EmergencyNotification',
            fields=[
                ('answer_id', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('author', models.CharField(max_length=255)),
                ('subject', models.CharField(max_length=255)),
                ('long_template', models.CharField(max_length=1000)),
                ('short_template', models.CharField(max_length=255)),
                ('mail_attempts', models.IntegerField(blank=True, default=0)),
                ('mail_success', models.IntegerField(blank=True, default=0)),
                ('telegram_attempts', models.IntegerField(blank=True, default=0)),
                ('telegram_success', models.IntegerField(blank=True, default=0)),
                ('yamb_attempts', models.IntegerField(blank=True, default=0)),
                ('yamb_success', models.IntegerField(blank=True, default=0)),
                ('sms_attempts', models.IntegerField(blank=True, default=0)),
                ('sms_success', models.IntegerField(blank=True, default=0)),
            ],
        ),
        migrations.CreateModel(
            name='EmergencyTestingList',
            fields=[
                ('login', models.CharField(max_length=255, primary_key=True, serialize=False)),
            ],
        )
    ]
