# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2018-04-11 13:46
from __future__ import unicode_literals

import django.contrib.postgres.fields
from django.db import migrations, models


OFFICES = [
    ('Москва, БЦ Морозов', 1, 1, 1, ['mosoffice-announces@yandex-team.ru']),
    ('Москва, БЦ Мамонтов', 1, 1, 147, ['mosoffice-announces@yandex-team.ru']),
    ('Москва, БЦ Строганов', 1, 1, 148, ['mosoffice-announces@yandex-team.ru']),
    ('Москва, БЦ Аврора', 1, 1, 181, ['mosoffice-announces@yandex-team.ru']),
    ('Москва, Сертификационный Центр Авто.ру', 1, 1, 177, ['mosoffice-announces@yandex-team.ru']),
    ('Москва, Офис Яндекс.Просвещение', 1, 1, 183, ['mosoffice-announces@yandex-team.ru']),
    ('Санкт-Петербург, БЦ Бенуа', 1, 2, 2, ['spb@yandex-team.ru', 'fire-spb@yandex-team.ru']),
    ('Нижний Новгород, БЦ Лобачевский Plaza', 1, 37, 161, ['nizhnynovgorod@yandex-team.ru', 'fire-nn@yandex-team.ru']),
    ('Нижний Новгород, Офис КЦ Вертикалей', 1, 37, 182, ['nizhnynovgorod@yandex-team.ru', 'fire-nn@yandex-team.ru']),
    ('Нижний Новгород, БЦ Свобода', 1, 37, 174, ['nizhnynovgorod@yandex-team.ru', 'fire-nn@yandex-team.ru']),
    ('Симферополь', 1, 8, 7, ['fire-sim@yandex-team.ru']),
    ('Екатеринбург, БЦ Палладиум', 1, 3, 3, ['ekb@yandex-team.ru', 'fire-ekb@yandex-team.ru']),
    ('Новосибирск, Академпарк', 1, 9, 179, ['nsk@yandex-team.ru']),
    ('Новосибирск, БЦ Гринвич', 1, 9, 4, ['academ@yandex-team.ru']),
    ('Казань', 1, 10, 143, ['kzn@yandex-team.ru']),
    ('Казань, Иннополис', 1, 10, 178, ['kzn@yandex-team.ru']),
    ('Ростов-на-Дону', 1, 26, 149, ['rnd-all@yandex-team.ru']),
    ('Беларусь, Минск', 6, 29, 151, ['belarus-office@yandex-team.ru'])
]


def init_offices(apps, schema_editor):
    Office = apps.get_model('uhura', 'Office')
    for office in OFFICES:
        name, country_code, city_code, office_code, emails = office
        Office.objects.create(
            name=name, country_code=country_code, city_code=city_code, office_code=office_code, emergency_emails=emails
        )


def remove_offices(apps, schema_editor):
    Office = apps.get_model('uhura', 'Office')
    Office.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('uhura', '0010_latesttgstatistics'),
    ]

    operations = [
        migrations.CreateModel(
            name='Office',
            fields=[
                ('name', models.CharField(max_length=255, unique=True)),
                ('country_code', models.CharField(db_index=True, max_length=255)),
                ('city_code', models.CharField(db_index=True, max_length=255)),
                ('office_code', models.CharField(max_length=255, primary_key=True, serialize=False)),
                (
                    'emergency_emails',
                    django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), size=None)
                ),
            ],
        ),
        migrations.RunPython(init_offices, remove_offices)
    ]
