# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2018-05-18 13:53
from __future__ import unicode_literals

import django.contrib.postgres.fields
from django.db import migrations, models


OFFICE_FLOORS_MAPPING = {
    '1': ['1', '2', '3', '4', '5', '6', '7', '24', '25', '43'],
    '2': ['10', '11', '12', '13', '14', '73'],
    '3': ['15', '21', '57', '76', '100'],
    '4': ['16'],
    '7': ['26', '27', '29', '30', '31', '32'],
    '143': ['22'],
    '147': ['8', '9', '41', '44', '64'],
    '148': ['35', '36', '37', '38', '54', '55', '56', '61', '62', '75'],
    '149': ['33'],
    '151': ['23', '66', '67', '68', '69'],
    '161': ['65', '107'],
    '174': ['84', '91'],
    '177': [],
    '178': ['40'],
    '179': ['93'],
    '182': [],
    '183': ['108', '109'],
    '181': ['96', '98', '99', '102', '103', '104', '105', '114', '116']
}


def add_floor_codes(apps, schema_editor):
    Office = apps.get_model('uhura', 'Office')
    for office_obj in Office.objects.all():
        office_obj.floor_codes = OFFICE_FLOORS_MAPPING[office_obj.office_code]
        office_obj.save()


def revert_floor_codes(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('uhura', '0013_user_blocked_cars_plates'),
    ]

    operations = [
        migrations.AddField(
            model_name='office',
            name='floor_codes',
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=255), default=list(), size=None
            ),
            preserve_default=False,
        ),
        migrations.RunPython(add_floor_codes, revert_floor_codes)
    ]
