# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
from django.db.models import Q


def migrate_from_old_table(apps, schema_editor):
    TelegramUsername = apps.get_model('uhura', 'TelegramUsername')
    User = apps.get_model('uhura', 'User')
    for user in User.objects.filter(~Q(telegram_username='') | ~Q(telegram_id='')):
        TelegramUsername.objects.create(
            user=user,
            username=user.telegram_username,
            telegram_id=user.telegram_id,
        )


class Migration(migrations.Migration):

    dependencies = [
        ('uhura', '0017_enlarge_your_phone'),
    ]

    operations = [
        migrations.CreateModel(
            name='TelegramUsername',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(blank=True, db_index=True, default='', max_length=255)),
                ('telegram_id', models.CharField(blank=True, db_index=True, default='', max_length=255)),
            ],
        ),
        migrations.AddField(
            model_name='telegramusername',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='telegram_usernames',
                                    to='uhura.User'),
        ),
        migrations.RunPython(code=migrate_from_old_table),
    ]
