from __future__ import unicode_literals

from datetime import datetime

from django.db import migrations, models
from django.utils import timezone


def fill_leave_at(apps, schema_editor):
    User = apps.get_model('uhura', 'User')
    users = User.objects.filter(quit_at__isnull=False)
    tzinfo = timezone.now().tzinfo

    for user in users:
        user.leave_at = tzinfo.localize(timezone.datetime.combine(user.quit_at, timezone.datetime.min.time()))
        user.save(update_fields=['leave_at'])


class Migration(migrations.Migration):

    dependencies = [
        ('uhura', '0031_add_leave_at_field'),
    ]

    operations = [
        migrations.RunPython(fill_leave_at),
    ]
