# coding: utf-8

from django.conf.urls import include, url

from uhura import views
from uhura.admin import admin_site


urlpatterns = [
    url(r'^webhook/(?P<token_hash>\w+)/$', views.WebhookView.get_webhook_view().as_view()),
    url(r'^ping/$', views.PingView.as_view()),
    url(r'^admin/', admin_site.urls),
    url(r'^emergency/$', views.EmergencySituationView.as_view()),
    url(r'^pending_updates/$', views.PendingUpdateCountMonitoringView.as_view()),
    url(r'^not_pushed/$', views.NotPushedMonitoringView.as_view()),
    url(r'^staff_monitoring/$', views.StaffSyncMonitoring.as_view(), name='staff_monitoring'),
    url(r'^api/idm/', include('django_idm_api.urls', namespace='idm-api')),
    url(r'^oauth_callback/$', views.PassportTokenCallbackView.as_view(), name='oauth_callback'),
]
